import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;

@ExtendWith(SpringExtension.class)
@SpringBootTest
@TestPropertySource(properties = {"app.message=Hello from inline properties"})
public class MyInlinePropertiesTest {

    @Value("${app.message}")
    private String appMessage;

    @Test
    public void testAppMessage() {
        assertEquals("Hello from inline properties", appMessage);
    }
}
